ORCA/M Asm65816 2.1.0

0001 C500                       TITLE 'Slot 5 Boot Code Space'
0002 C500
0003 C500              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 C500              ;	by EdAsmCvtIIGS version 1.2d7 on 5/16/91 at 1:21:49 PM
0005 C500
0006 C500              ***************************************************
0007 C500              *
0008 C500              * Auto Boot signature bytes
0009 C500              * This is also the boot (auto & PR#5) entry point.
0010 C500              *
0011 C500              * The 65816 processor environment must be in full
0012 C500              * emulation mode when using this entry point.
0013 C500              *
0014 C500              *         Data Bank Register   = $00
0015 C500              *         Direct Page Register = $0000
0016 C500              *         Emulation Flag (e)   = 1
0017 C500              *
0018 C500              ***************************************************
0019 C500 A2 20                 LDX   #$20
0020 C502 A2 00                 LDX   #$00
0021 C504 A2 03                 LDX   #$03
0022 C506 C9 00                 CMP   #0                       ; Flag that this is a boot
0023 C508 B0 0C                 BCS   bootcase5                ; Skip to prep for $C800 trip
0024 C50A
0025 C50A              ***************************************************
0026 C50A              *
0027 C50A              * ProDOS Block Device Driver entry point
0028 C50A              *
0029 C50A              * The 65816 processor environment must be in full
0030 C50A              * emulation mode when using this entry point.
0031 C50A              *
0032 C50A              *         Data Bank Register   = $00
0033 C50A              *         Direct Page Register = $0000
0034 C50A              *         Emulation Flag (e)   = 1
0035 C50A              *
0036 C50A              * Input parameters are as follows:
0037 C50A              *
0038 C50A              *         $000042 = ProDOS Block Device command
0039 C50A              *         $000043 = Unit Number
0040 C50A              *         $000044 = Buffer Address (low byte)
0041 C50A              *         $000045 = Buffer Address (high byte)
0042 C50A              *         $000046 = Block Address (low byte)
0043 C50A              *         $000047 = Block Address (high byte)
0044 C50A              *
0045 C50A              ***************************************************
0046 C50A              PRODOSENTRY EQU   *
0047 C50A 38                    SEC   
0048 C50B B0 01                 BCS   MakeFlag                 ; Skip the clear
0049 C50D                       EJECT 
0050 C50D              ***************************************************
0051 C50D              *
0052 C50D              * This is the SmartPort entry point
0053 C50D              *
0054 C50D              * The 65816 processor environment must be in full
0055 C50D              * emulation mode when using this entry point.
0056 C50D              *
0057 C50D              *         Data Bank Register   = $00
0058 C50D              *         Direct Page Register = $0000
0059 C50D              *         Emulation Flag (e)   = 1
0060 C50D              *
0061 C50D              * Standard SmartPort calls are executed from bank $00
0062 C50D              * as follows:
0063 C50D              *
0064 C50D              *         jsr   SPentry       ; Call to SmartPort
0065 C50D              *         dfb   Command       ; Define SmartPort command
0066 C50D              *         dw    ParmList      ; Pointer in bank 0 to parameter list
0067 C50D              *         bcs   error         ; SmartPort returns here
0068 C50D              *
0069 C50D              * Extended SmartPort calls are executed from bank $00
0070 C50D              * as follows:
0071 C50D              *
0072 C50D              *         jsr   SPentry       ; Call to SmartPort
0073 C50D              *         dfb   Command+$40   ; Define SmartPort command
0074 C50D              *         dw    ParmList      ; Pointer to parameter list
0075 C50D              *         dw    ^ParmList     ; 
0076 C50D              *         bcs   error         ; SmartPort returns here
0077 C50D              *
0078 C50D              ***************************************************
0079 C50D              SPENTRY  EQU   *                        ; Only in //GS version
0080 C50D 18                    CLC   
0081 C50E              MAKEFLAG EQU   *
0082 C50E 6A                    ROR   a
0083 C50F 29 80                 AND   #%10000000               ; make sure boot flag cleared
0084 C511 8F B0 0F E1           STA   >ProFLAG                 ; Bit [7] = 1 if ProDOS, = 0 if SP
0085 C515 18                    CLC                            ; This is not a boot entry
0086 C516              BOOTCASE5 EQU   *
0087 C516 90 06                 BCC   bc5                      ; if not a boot
0088 C518 A9 C0                 LDA   #%11000000               ; Bit [6] = 1 if boot
0089 C51A 8F B0 0F E1           STA   >ProFLAG
0090 C51E              BC5      EQU   *
0091 C51E FB                    XCE                            ; save carry for mode switch
0092 C51F 18                    CLC                            ; going to native mode
0093 C520 FB                    XCE                            ; switch mode & restore carry
0094 C521 E2 30                 SEP   #$30                     ; 8 bit 'm' & 'x'
0095 C523 A9 C5                 LDA   #$C5                     ; Load value for MSLOT
0096 C525 8D F8 07              STA   |MSlot
0097 C528 A9 04                 LDA   #4                       ; set command retry counter
0098 C52A 8F CB 0F E1           STA   >CmdRetry
0099 C52E 08                    PHP                            ; save entry flag
0100 C52F 8B                    PHB                            ; save last data bank
0101 C530 A9 00                 LDA   #00                      ;force caller to call from bank 00
0102 C532 48                    PHA   
0103 C533 AB                    PLB   
0104 C534 AD 36 C0              LDA   |cyareg                  ; get callers mode
0105 C537 48                    PHA                            ; and save it
0106 C538 8F CC 0F E1           STA   >CyaSave                 ; save it here !!!
0107 C53C 29 FB                 AND   #%11111011               ; Fast Mode & disable slot 6 motor detect 
0108 C53E 09 80                 ORA   #%10000000
0109 C540 8D 36 C0              STA   |cyareg
0110 C543 A3 03                 LDA   3,s                      ; get entry flag
0111 C545 4A                    LSR   a                        ; restore entry flag
0112 C546 22 06 56 FF           JSL   >SPdriver+6              ; off to bank $FF thru jmp table
0113 C54A                       EJECT 
0114 C54A              *
0115 C54A              * Returns here from bank $FF when done.
0116 C54A              *
0117 C54A EB                    XBA                            ; save error code
0118 C54B 68                    PLA                            ; restore system speed
0119 C54C AF CC 0F E1           LDA   >CyaSave
0120 C550 8D 36 C0              STA   |cyareg
0121 C553 08                    PHP                            ; save error flag
0122 C554 38                    SEC                            ; set emulation mode
0123 C555 FB                    XCE   
0124 C556 28                    PLP                            ; restore error flag
0125 C557 AB                    PLB                            ; restore last data bank
0126 C558 68                    PLA                            ; clean up stack (EntryFlag)
0127 C559 EB                    XBA                            ; restore error code
0128 C55A 48                    PHA                            ; save error code
0129 C55B AF B0 0F E1           LDA   >ProFLAG                 ; return from boot?
0130 C55F 29 40                 AND   #%01000000
0131 C561 D0 02                 BNE   bootcheck                ; yes
0132 C563 68                    PLA                            ; restore error info
0133 C564 60                    RTS   
0134 C565              *
0135 C565              *
0136 C565              * Do this code if the boot can't be done.
0137 C565              *  If this was an autoboot (loc=$CN00), continue the slot scan.
0138 C565              *  If not, drop into basic after issuing appropriate message
0139 C565              *
0140 C565              *
0141 C565              BOOTCHECK EQU   *
0142 C565 A9 00                 LDA   #00
0143 C567 48                    PHA   
0144 C568 AB                    PLB                            ;force bank 00 just in case
0145 C569 A9 08                 LDA   #%00001000
0146 C56B 8D 35 C0              STA   |shadow                  ; video shadowing in except SuperHires
0147 C56E 68                    PLA                            ; restore error info
0148 C56F B0 03                 BCS   bootfail
0149 C571 4C 01 08              JMP   |$0801                   ; and away we go!
0150 C574              BOOTFAIL EQU   *
0151 C574 A6 00                 LDX   loc0
0152 C576 D0 0A                 BNE   noauto                   ; if from PR#s
0153 C578 A5 01                 LDA   loc1
0154 C57A CD F8 07              CMP   |MSlot
0155 C57D D0 03                 BNE   noauto                   ; if from PR#s
0156 C57F 4C BA FA              JMP   autoscan                 ; continue slot scan
0157 C582              NOAUTO   EQU   *
0158 C582 4C 00 E0              JMP   Basic
0159 C585              *
0160 C585 20 93 FE     C5BOOTM: JSR   setvid                   ; set back the hooks
0161 C588 20 89 FE              JSR   setkbd
0162 C58B 20 39 FB              JSR   text
0163 C58E 20 58 FC              JSR   home
0164 C591 A9 0A                 LDA   #$0A
0165 C593 85 25                 STA   cv
0166 C595 64 24                 STZ   ch
0167 C597 20 22 FC              JSR   vtab
0168 C59A 6B                    RTL   
0169 C59B              *
0170 C59B              PARMCTAB:  
0171 C59B 03                    DC B:%00000011                 ;status:  3 parms/no data send
0172 C59C 03                    DC B:%00000011                 ;read:    3 parms/no data send
0173 C59D 83                    DC B:%10000011                 ;write:   3 parms/data send
0174 C59E 01                    DC B:%00000001                 ;format:  1 parm/no data send
0175 C59F 83                    DC B:%10000011                 ;control: 3 parms/data send
0176 C5A0 01                    DC B:%00000001                 ;init:    1 parm/no data send
0177 C5A1 01                    DC B:%00000001                 ;open:    1 parm/no data send
0178 C5A2 01                    DC B:%00000001                 ;close:   1 parm/no data send
0179 C5A3 04                    DC B:%00000100                 ;charRead:4 params/no data send
0180 C5A4 84                    DC B:%10000100                 ;CharWr:  4 parms/data send
0181 C5A5 83                    DC B:%10000011                 ;SetFmtOpts 3 p/data send 
0182 C5A6 03                    DC B:%00000011                 ;GetFmtOpts 3 p/no data send
0183 C5A7 84                    DC B:%10000100                 ;RawRead    4 p/   data send
0184 C5A8              *
0185 C5A8              *
0186 C5A8              * Shift tables for use when reading.  Each table should not
0187 C5A8              * straddle pages.
0188 C5A8              *
0189 C5A8 80 80 80 80  SHIFT1   DC B:$80,$80,$80,$80,$80,$80,$80,$80
0190 C5B0 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$00
0191 C5B8 80 80 80 80  SHIFT2   DC B:$80,$80,$80,$80,$00,$00,$00,$00
0192 C5C0 80 80 80 80           DC B:$80,$80,$80,$80,$00,$00,$00,$00
0193 C5C8 80 80 00 00  SHIFT3   DC B:$80,$80,$00,$00,$80,$80,$00,$00
0194 C5D0 80 80 00 00           DC B:$80,$80,$00,$00,$80,$80,$00,$00
0195 C5D8 80 00 80 00  SHIFT4   DC B:$80,$00,$80,$00,$80,$00,$80,$00
0196 C5E0 80 00 80 00           DC B:$80,$00,$80,$00,$80,$00,$80,$00
0197 C5E8              *
0198 C5E8              *
0199 C5E8              *
0200 C5E8              * This table, when sent in reverse order, profides a
0201 C5E8              *  sync pattern used to synchronize the drive IWM with
0202 C5E8              *  the data stream.  The first byte (last sent) is the
0203 C5E8              *  packet begin mark.
0204 C5E8              *
0205 C5E8              *
0206 C5E8 C3           PREAMBLE DC B:PACKETBEG
0207 C5E9 FF FC F3 CF  SYNCTAB  DC B:$FF,$FC,$F3,$CF,$3F
0208 C5EE              *
0209 C5EE 00 00 00 00           DC B:13,0
0210 C5FB              *
0211 C5FB C0                    DC B:PCID2
0212 C5FC 00 00                 DC W:0                         ; Total Blocks (force stat call)
0213 C5FE BF                    DC B:PDIDBYTE                  ; ProDOS ID byte
0214 C5FF 0A                    DC B:PRODOSENTRY               ; Low byte of ProDOS entry pt
